/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.pa.domain;

import com.ibm.hsc.ccfw.pa.system.PIBpa;
import com.ibm.hsc.ccfw.pa.system.PIBpcFsp;
import com.ibm.hsc.ccfw.pa.system.PICecFsp;
import com.ibm.hsc.ccfw.pa.system.PIMachineSystem;
import com.ibm.hwmca.base.pa.system.RemoteConsoleSystem;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.pa.util.LockAcquisitionException;
import com.ibm.hwmca.fw.pa.util.LockHeldException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.event.PowerDomainAnalysisEvent;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.pa.event.AnalysisDomainAnalysisEvent;
import com.ibm.hwmca.xfw.pa.system.RemoteMachineSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemManager;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PowerAnalysisDomain
extends DistributedAnalysisDomain {
    private static final String TRACE_MASKT = "PPAPWADT";
    private static final String TRACE_MASKF = "PPAPWADF";
    private static final String TRACE_MASKD = "PPAPWADD";
    protected static boolean buildingInitialDomains = true;
    protected PICecFsp owningCec = null;

    public PowerAnalysisDomain() {
        Trace.trace((String)TRACE_MASKD, (Object)"<-> ctor v 11.17.04");
    }

    public PowerAnalysisDomain(DomainIdentifier domainIdentifier) {
        super(domainIdentifier);
    }

    protected Set instantiateDomains() {
        Trace.trace((String)TRACE_MASKD, (Object)"--> instantiateDomains");
        this.realInstanceSet = new HashSet();
        buildingInitialDomains = true;
        try {
            Object object;
            PowerAnalysisDomain powerAnalysisDomain;
            Trace.trace((String)TRACE_MASKD, (Object)"building unique domains for each 24 inch Frame-BPA");
            Set set = RemoteSystemManager.getRemoteSystemManager().getLiveSystems(((Object)((Object)new PIBpa())).getClass());
            Iterator iterator = set.iterator();
            PIBpa pIBpa = null;
            while (iterator.hasNext()) {
                pIBpa = (PIBpa)((Object)iterator.next());
                powerAnalysisDomain = this.instantiatePowerDomain(pIBpa);
                if (!pIBpa.isCecInFrame()) {
                    Trace.trace((String)TRACE_MASKF, (Object)"got an IO only BPA Frame");
                    object = pIBpa.findOwningCec();
                    if (object != null) {
                        Trace.trace((String)TRACE_MASKF, (Object)"found an owning CEC");
                        powerAnalysisDomain.addOwningCec((PICecFsp)((Object)object));
                        continue;
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)"couldn't find an owning cec for the frame");
                    continue;
                }
                Trace.trace((String)TRACE_MASKF, (Object)"non I/O BPA");
            }
            powerAnalysisDomain = null;
            Trace.trace((String)TRACE_MASKD, (Object)"add the known BPC FSP's to their corresponding BPA");
            object = RemoteSystemManager.getRemoteSystemManager().getLiveSystems(((Object)((Object)new PIBpcFsp())).getClass());
            Iterator iterator2 = object.iterator();
            PIBpcFsp pIBpcFsp = null;
            while (iterator2.hasNext()) {
                pIBpcFsp = (PIBpcFsp)((Object)iterator2.next());
                if (pIBpcFsp.getEncapsulatingBpa() == null) {
                    Trace.trace((String)TRACE_MASKD, (Object)" encapsulating bpa was null - continue");
                    continue;
                }
                try {
                    Trace.trace((String)TRACE_MASKD, (Object)("get the real domain for " + pIBpcFsp.getEncapsulatingBpa().getMTMS()));
                    powerAnalysisDomain = (PowerAnalysisDomain)this.getDomain(pIBpcFsp.getEncapsulatingBpa().getMTMS());
                    if (powerAnalysisDomain == null) {
                        Trace.trace((String)TRACE_MASKD, (Object)"couln't find the real domain ????");
                        continue;
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)("Associating [" + pIBpcFsp.getUniqueCIMKey() + "] with domain [" + powerAnalysisDomain.getDomainId().getDID() + "]"));
                    powerAnalysisDomain.addMonitoredRemoteMachineSystem(pIBpcFsp);
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKT, (Object)"Exception caught - ignoring system");
                    Trace.trace((String)TRACE_MASKT, (Object)exception);
                }
            }
            Trace.trace((String)TRACE_MASKD, (Object)"now hook the CEC FSPs to the BPA");
            Trace.trace((String)TRACE_MASKD, (Object)"keo this is the test code");
            Set set2 = RemoteSystemManager.getRemoteSystemManager().getLiveSystems(((Object)((Object)new PICecFsp())).getClass());
            Iterator iterator3 = set2.iterator();
            PICecFsp pICecFsp = null;
            while (iterator3.hasNext()) {
                pICecFsp = (PICecFsp)((Object)iterator3.next());
                Trace.trace((String)TRACE_MASKD, (Object)("working with CecFSP " + pICecFsp.getMTMS()));
                pIBpa = PIBpa.findAssociatedBPA(pICecFsp);
                if (pIBpa != null) {
                    try {
                        powerAnalysisDomain = (PowerAnalysisDomain)this.getDomain(pIBpa.getMTMS());
                        if (powerAnalysisDomain == null) {
                            Trace.trace((String)TRACE_MASKD, (Object)"real domain null ????");
                            continue;
                        }
                        Trace.trace((String)TRACE_MASKF, (Object)("Associating [" + pICecFsp.getUniqueCIMKey() + "] with domain [" + powerAnalysisDomain.getDomainId().getDID() + "]"));
                        powerAnalysisDomain.addMonitoredRemoteMachineSystem(pICecFsp);
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKT, (Object)"Exception caught - ignoring system");
                        Trace.trace((String)TRACE_MASKT, (Object)exception);
                    }
                    continue;
                }
                this.instantiatePowerDomain(pICecFsp);
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKT, (Object)"Exception caught building domains");
            Trace.trace((String)TRACE_MASKT, (Object)exception);
        }
        super.instantiateDomains();
        buildingInitialDomains = false;
        Trace.trace((String)TRACE_MASKD, (Object)"<-- instantiateDomains");
        return this.realInstanceSet;
    }

    public void addOwningCec(PICecFsp pICecFsp) {
        Trace.trace((String)TRACE_MASKD, (Object)("setting owning cec as [" + pICecFsp.getMTMS() + "]"));
        this.owningCec = pICecFsp;
    }

    public void removeOwningCec() {
        this.owningCec = null;
    }

    public PICecFsp getOwningCec() {
        return this.owningCec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PowerAnalysisDomain instantiatePowerDomain(PIMachineSystem pIMachineSystem) {
        Trace.trace((String)TRACE_MASKF, (Object)("building domain instance [" + pIMachineSystem.getMTMS() + "]"));
        PowerAnalysisDomain powerAnalysisDomain = new PowerAnalysisDomain();
        powerAnalysisDomain.setDomainId(new DomainIdentifier(pIMachineSystem.getMTMS()));
        HashSet<PIMachineSystem> hashSet = new HashSet<PIMachineSystem>();
        hashSet.add(pIMachineSystem);
        powerAnalysisDomain.setMonitoredRemoteMachineSystems(hashSet);
        Set set = this.realInstanceSet;
        synchronized (set) {
            this.realInstanceSet.add(powerAnalysisDomain);
        }
        return powerAnalysisDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePowerDomain(DomainIdentifier domainIdentifier) {
        Set set = this.realInstanceSet;
        synchronized (set) {
            Iterator iterator = this.realInstanceSet.iterator();
            PowerAnalysisDomain powerAnalysisDomain = null;
            while (iterator.hasNext()) {
                powerAnalysisDomain = (PowerAnalysisDomain)((Object)iterator.next());
                if (!powerAnalysisDomain.getDomainId().equals((Object)domainIdentifier)) continue;
                Trace.trace((String)TRACE_MASKD, (Object)("removing domain instance [" + powerAnalysisDomain.getDomainId().getDID() + "]"));
                iterator.remove();
                powerAnalysisDomain.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedAnalysisDomain getDomain(String string) {
        PowerAnalysisDomain powerAnalysisDomain = null;
        if (buildingInitialDomains) {
            Set set = this.realInstanceSet;
            synchronized (set) {
                Iterator iterator = this.realInstanceSet.iterator();
                while (iterator.hasNext()) {
                    powerAnalysisDomain = (PowerAnalysisDomain)((Object)iterator.next());
                    if (!powerAnalysisDomain.getDomainId().getDID().equals(string)) continue;
                    return powerAnalysisDomain;
                }
            }
            return null;
        }
        try {
            Set set = DomainManager.getDomainManager().getDomains(((Object)((Object)this)).getClass().getName());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                powerAnalysisDomain = (PowerAnalysisDomain)((Object)iterator.next());
                if (!powerAnalysisDomain.doesMonitor(string)) continue;
                return powerAnalysisDomain;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public boolean doesMonitor(String string) {
        Set set = this.getMonitoredRemoteMachineSystems();
        Iterator iterator = set.iterator();
        PASystem pASystem = null;
        while (iterator.hasNext()) {
            pASystem = (PASystem)iterator.next();
            if (!pASystem.getMTMS().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected void remoteMachineAdd(RemoteMachineSystem remoteMachineSystem) {
        Trace.trace((String)TRACE_MASKF, (Object)("<-> remoteMachineAdd: " + remoteMachineSystem.getMTMS()));
        PowerAnalysisDomain powerAnalysisDomain = null;
        if (remoteMachineSystem instanceof PIBpa) {
            PIBpa pIBpa = (PIBpa)remoteMachineSystem;
            try {
                powerAnalysisDomain = this.instantiatePowerDomain(pIBpa);
                this.builderSetup(powerAnalysisDomain);
                Set set = RemoteSystemManager.getRemoteSystemManager().getLiveSystems(((Object)((Object)new PIBpcFsp())).getClass());
                Iterator iterator = set.iterator();
                PIBpcFsp pIBpcFsp = null;
                PIBpa pIBpa2 = null;
                while (iterator.hasNext()) {
                    pIBpcFsp = (PIBpcFsp)((Object)iterator.next());
                    pIBpa2 = pIBpcFsp.getEncapsulatingBpa();
                    if (pIBpa2 == null || pIBpa2.getMTMS().equals(pIBpa.getMTMS())) continue;
                    Trace.trace((String)TRACE_MASKF, (Object)("Associating [" + pIBpcFsp.getUniqueCIMKey() + "] with domain [" + powerAnalysisDomain.getDomainId().getDID() + "]"));
                    powerAnalysisDomain.addMonitoredRemoteMachineSystem(pIBpcFsp);
                }
                Set set2 = pIBpa.getAssociatedCECs();
                if (set2 != null && set2.size() > 0) {
                    Iterator iterator2 = set2.iterator();
                    PICecFsp pICecFsp = null;
                    while (iterator2.hasNext()) {
                        pICecFsp = (PICecFsp)((Object)iterator2.next());
                        this.removePowerDomain(new DomainIdentifier(pICecFsp.getMTMS()));
                        Trace.trace((String)TRACE_MASKF, (Object)("Associating [" + pICecFsp.getUniqueCIMKey() + "] with domain [" + powerAnalysisDomain.getDomainId().getDID() + "]"));
                        powerAnalysisDomain.addMonitoredRemoteMachineSystem(pICecFsp);
                    }
                }
                powerAnalysisDomain.initialize();
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKT, (Object)"Exception caught building domain");
                Trace.trace((String)TRACE_MASKT, (Object)exception);
            }
        } else if (remoteMachineSystem instanceof PIBpcFsp) {
            PIBpcFsp pIBpcFsp = (PIBpcFsp)remoteMachineSystem;
            PIBpa pIBpa = pIBpcFsp.getEncapsulatingBpa();
            if (pIBpa != null) {
                try {
                    powerAnalysisDomain = (PowerAnalysisDomain)this.getDomain(pIBpa.getMTMS());
                    if (powerAnalysisDomain == null) {
                        Trace.trace((String)TRACE_MASKF, (Object)("No power domain found for [" + pIBpcFsp.getUniqueCIMKey() + "] (no frame yet?).  Ignoring BPC."));
                        return;
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)("Associating [" + pIBpcFsp.getUniqueCIMKey() + "] with domain [" + powerAnalysisDomain.getDomainId().getDID() + "]"));
                    powerAnalysisDomain.addMonitoredRemoteMachineSystem(pIBpcFsp);
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKT, (Object)"Exception caught - ignoring system");
                    Trace.trace((String)TRACE_MASKT, (Object)exception);
                }
            }
        } else if (remoteMachineSystem instanceof PICecFsp) {
            PICecFsp pICecFsp = (PICecFsp)remoteMachineSystem;
            PIBpa pIBpa = PIBpa.findAssociatedBPA(pICecFsp);
            if (pIBpa != null) {
                try {
                    powerAnalysisDomain = (PowerAnalysisDomain)this.getDomain(pIBpa.getMTMS());
                    Trace.trace((String)TRACE_MASKF, (Object)("Associating [" + pICecFsp.getUniqueCIMKey() + "] with domain [" + powerAnalysisDomain.getDomainId().getDID() + "]"));
                    powerAnalysisDomain.addMonitoredRemoteMachineSystem(pICecFsp);
                    if (powerAnalysisDomain.getPrimary() == null) {
                        powerAnalysisDomain.beginSynchronization();
                    }
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKT, (Object)"Exception caught - ignoring system");
                    Trace.trace((String)TRACE_MASKT, (Object)exception);
                }
            } else {
                try {
                    powerAnalysisDomain = this.instantiatePowerDomain(pICecFsp);
                    this.builderSetup(powerAnalysisDomain);
                    powerAnalysisDomain.initialize();
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKT, (Object)"Exception caught building domain");
                    Trace.trace((String)TRACE_MASKT, (Object)exception);
                }
            }
        }
    }

    protected void remoteMachineRemove(RemoteMachineSystem remoteMachineSystem) {
        Trace.trace((String)TRACE_MASKF, (Object)("<-> remoteMachineRemove: " + remoteMachineSystem.getMTMS()));
        PowerAnalysisDomain powerAnalysisDomain = null;
        if (remoteMachineSystem instanceof PIBpa) {
            PIBpa pIBpa = (PIBpa)remoteMachineSystem;
            this.removePowerDomain(new DomainIdentifier(pIBpa.getMTMS()));
        } else if (remoteMachineSystem instanceof PIBpcFsp) {
            PIBpcFsp pIBpcFsp = (PIBpcFsp)remoteMachineSystem;
            try {
                powerAnalysisDomain = (PowerAnalysisDomain)this.getDomain(pIBpcFsp.getEncapsulatingBpa().getMTMS());
                if (powerAnalysisDomain == null) {
                    Trace.trace((String)TRACE_MASKF, (Object)("No power domain found for [" + pIBpcFsp.getUniqueCIMKey() + "] (no frame yet?).  Ignoring BPC."));
                    return;
                }
                Trace.trace((String)TRACE_MASKF, (Object)("Disassociating [" + pIBpcFsp.getUniqueCIMKey() + "] with domain [" + powerAnalysisDomain.getDomainId().getDID() + "]"));
                powerAnalysisDomain.removeMonitoredRemoteMachineSystem(pIBpcFsp);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKT, (Object)"Exception caught - ignoring system");
                Trace.trace((String)TRACE_MASKT, (Object)exception);
            }
        } else if (remoteMachineSystem instanceof PICecFsp) {
            PICecFsp pICecFsp = (PICecFsp)remoteMachineSystem;
            PIBpa pIBpa = PIBpa.findAssociatedBPA(pICecFsp);
            if (pIBpa != null) {
                try {
                    powerAnalysisDomain = (PowerAnalysisDomain)this.getDomain(pIBpa.getMTMS());
                    Trace.trace((String)TRACE_MASKF, (Object)("Disassociating [" + pICecFsp.getUniqueCIMKey() + "] with domain [" + powerAnalysisDomain.getDomainId().getDID() + "]"));
                    powerAnalysisDomain.removeMonitoredRemoteMachineSystem(pICecFsp);
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKT, (Object)"Exception caught - ignoring system");
                    Trace.trace((String)TRACE_MASKT, (Object)exception);
                }
            } else {
                this.removePowerDomain(new DomainIdentifier(pICecFsp.getMTMS()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteConsoleAdd(RemoteConsoleSystem remoteConsoleSystem) {
        if (this.getParticipants().contains(remoteConsoleSystem)) {
            return;
        }
        super.remoteConsoleAdd(remoteConsoleSystem);
        HashSet<RemoteConsoleSystem> hashSet = this.synchDataLock;
        synchronized (hashSet) {
            if (!this.performingSynchronization && this.getPrimary() == null) {
                this.beginSynchronization();
            }
        }
        hashSet = new HashSet<RemoteConsoleSystem>();
        hashSet.add(remoteConsoleSystem);
        this.beginProblemDataSynchronization(hashSet);
    }

    protected void remoteConsoleRemove(RemoteConsoleSystem remoteConsoleSystem) {
        super.remoteConsoleRemove(remoteConsoleSystem);
        if (this.getPrimary() == null) {
            this.beginSynchronization();
        }
    }

    public void beginPrimaryArbitration() {
        this.setPrimary((PASystem)localConsole);
        Set set = this.getParticipants();
        Iterator iterator = set.iterator();
        RemoteConsoleSystem remoteConsoleSystem = null;
        while (iterator.hasNext()) {
            remoteConsoleSystem = (RemoteConsoleSystem)iterator.next();
            try {
                this.publishPrimaryData(remoteConsoleSystem, (Serializable)((Object)"PART_DAD_PRIME_UPDATE"));
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKT, (Object)this.getDomainTrace("couldn't publish primary data to " + remoteConsoleSystem));
                Trace.trace((String)TRACE_MASKT, (Object)exception);
            }
        }
    }

    protected boolean isPrimaryAcceptible() {
        return true;
    }

    protected void acquireArbitrationLock() throws LockAcquisitionException, LockHeldException {
        Object object = null;
        boolean bl = false;
        Set set = this.getMonitoredRemoteMachineSystems();
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && !bl) {
            object = (PASystem)iterator.next();
            if (!(object instanceof PICecFsp)) continue;
            bl = true;
        }
        if (!bl) {
            if (this.owningCec != null) {
                Trace.trace((String)TRACE_MASKF, (Object)("This is an I/O Frame. The lock holder is [" + this.owningCec.getMTMS() + "]"));
                object = this.owningCec;
            } else {
                Trace.trace((String)TRACE_MASKD, (Object)this.getDomainTrace("<-> acquireArbitrationLock (No lock system for domain)"));
                throw new LockAcquisitionException();
            }
        }
        ((PICecFsp)((Object)object)).acquireLock(PICecFsp.ARBITRATION_LOCK);
    }

    protected void releaseArbitrationLock() throws LockAcquisitionException {
        Object object = null;
        boolean bl = false;
        Set set = this.getMonitoredRemoteMachineSystems();
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && !bl) {
            object = (PASystem)iterator.next();
            if (!(object instanceof PICecFsp)) continue;
            bl = true;
        }
        if (!bl) {
            if (this.owningCec != null) {
                Trace.trace((String)TRACE_MASKF, (Object)("This is an I/O Frame. The lock holder is [" + this.owningCec.getMTMS() + "]"));
                object = this.owningCec;
            } else {
                Trace.trace((String)TRACE_MASKD, (Object)this.getDomainTrace("<-> acquireArbitrationLock (No lock system for domain)"));
                throw new LockAcquisitionException();
            }
        }
        ((PICecFsp)((Object)object)).releaseLock(PICecFsp.ARBITRATION_LOCK);
    }

    protected PASystem getArbitrationLockHolder() throws LockAcquisitionException {
        PASystem pASystem;
        Object object = null;
        boolean bl = false;
        Set set = this.getMonitoredRemoteMachineSystems();
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && !bl) {
            object = (PASystem)iterator.next();
            if (!(object instanceof PICecFsp)) continue;
            bl = true;
        }
        if (!bl) {
            if (this.owningCec != null) {
                Trace.trace((String)TRACE_MASKF, (Object)("This is an I/O Frame. The lock holder is [" + this.owningCec.getMTMS() + "]"));
                object = this.owningCec;
            } else {
                Trace.trace((String)TRACE_MASKD, (Object)this.getDomainTrace("<-> getArbitrationLockHolder (No lock system for domain)"));
                throw new LockAcquisitionException();
            }
        }
        if ((pASystem = ((PICecFsp)((Object)object)).getLockHolder(PICecFsp.ARBITRATION_LOCK)) == null) {
            return null;
        }
        if (pASystem.getMTMS().equals(localConsole.getMTMS())) {
            return localConsole;
        }
        RemoteConsoleSystem remoteConsoleSystem = null;
        Iterator iterator2 = this.getParticipants().iterator();
        while (iterator2.hasNext()) {
            remoteConsoleSystem = (RemoteConsoleSystem)iterator2.next();
            if (!pASystem.getMTMS().equals(remoteConsoleSystem.getMTMS())) continue;
            return remoteConsoleSystem;
        }
        remoteConsoleSystem = new RemoteConsoleSystem();
        remoteConsoleSystem.setMachineType(pASystem.getMachineType());
        remoteConsoleSystem.setMachineModel(pASystem.getMachineModel());
        remoteConsoleSystem.setMachineSerial(pASystem.getMachineSerial());
        remoteConsoleSystem.setSystemName(remoteConsoleSystem.getMTMS());
        return remoteConsoleSystem;
    }

    protected boolean synchronizeProblemDataDuringInitialization() {
        return true;
    }

    public AnalysisDomainAnalysisEvent getSystemAnalysisEvent(Object object) {
        return new PowerDomainAnalysisEvent(object);
    }
}

